% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_headers.R
\name{add_header_lines}
\alias{add_header_lines}
\alias{add_footer_lines}
\title{Add a label in a header or footer new row.}
\usage{
add_header_lines(x, values = character(0), top = TRUE)

add_footer_lines(x, values = character(0), top = FALSE)
}
\arguments{
\item{x}{a \code{flextable} object}

\item{values}{a character vector, each element will be added a a new
row in the header or footer part.}

\item{top}{should the row be inserted at the top or the bottom.}
}
\description{
Add an header or footer new row made of one cell.
This is a sugar function to be used when you need to add a
title row to a flextable, most of the time it will be used in a
context of adding a footnote or adding a title on the top line
of the flextable.
}
\section{Illustrations}{


\if{html}{\figure{fig_add_header_lines_1.png}{options: width="400"}}

\if{html}{\figure{fig_add_header_lines_2.png}{options: width="400"}}
}

\examples{

ft_1 <- flextable( head( iris ) )
ft_1 <- add_header_lines(ft_1, values = "blah blah")
ft_1 <- add_header_lines(ft_1, values = c("blah 1", "blah 2"))
ft_1 <- autofit(ft_1)
ft_1
ft_2 <- flextable( head( iris ) )
ft_2 <- add_footer_lines(ft_2, values = "blah blah")
ft_2 <- add_footer_lines(ft_2, values = c("blah 1", "blah 2"))
ft_2 <- theme_tron(ft_2)
ft_2
}
\seealso{
Other headers and footers: 
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{set_header_footer_df}},
\code{\link{set_header_labels}()}
}
\concept{headers and footers}
