% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_headers.R
\name{set_header_footer_df}
\alias{set_header_footer_df}
\alias{set_header_df}
\alias{set_footer_df}
\title{Set flextable's header or footer rows}
\usage{
set_header_df(x, mapping = NULL, key = "col_keys")

set_footer_df(x, mapping = NULL, key = "col_keys")
}
\arguments{
\item{x}{a \code{flextable} object}

\item{mapping}{a \code{data.frame} specyfing for each colname
content of the column.}

\item{key}{column to use as key when joigning data_mapping.}
}
\description{
Use a data.frame to specify flextable's header or footer rows.

The data.frame must contain a column whose values match flextable
\code{col_keys} argument, this column will be used as join key. The
other columns will be displayed as header or footer rows. The leftmost column
is used as the top header/footer row and the rightmost column
is used as the bottom header/footer row.
}
\section{Illustrations}{


\if{html}{\figure{fig_set_header_footer_df_1.png}{options: width="400"}}

\if{html}{\figure{fig_set_header_footer_df_2.png}{options: width="400"}}
}

\examples{
typology <- data.frame(
  col_keys = c( "Sepal.Length", "Sepal.Width", "Petal.Length",
                "Petal.Width", "Species" ),
  what = c("Sepal", "Sepal", "Petal", "Petal", "Species"),
  measure = c("Length", "Width", "Length", "Width", "Species"),
  stringsAsFactors = FALSE )

ft_1 <- flextable( head( iris ))
ft_1 <- set_header_df(ft_1, mapping = typology, key = "col_keys" )
ft_1 <- merge_h(ft_1, part = "header")
ft_1 <- merge_v(ft_1, j = "Species", part = "header")
ft_1 <- theme_vanilla(ft_1)
ft_1 <- fix_border_issues(ft_1)
ft_1


typology <- data.frame(
  col_keys = c( "Sepal.Length", "Sepal.Width", "Petal.Length",
                "Petal.Width", "Species" ),
  unit = c("(cm)", "(cm)", "(cm)", "(cm)", ""),
  stringsAsFactors = FALSE )
ft_2 <- set_footer_df(ft_1, mapping = typology, key = "col_keys" )
ft_2 <- italic(ft_2, italic = TRUE, part = "footer" )
ft_2 <- theme_booktabs(ft_2)
ft_2 <- fix_border_issues(ft_2)
ft_2
}
\seealso{
Other headers and footers: 
\code{\link{add_header_lines}()},
\code{\link{add_header_row}()},
\code{\link{add_header}()},
\code{\link{set_header_labels}()}
}
\concept{headers and footers}
