% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{save_as_docx}
\alias{save_as_docx}
\title{save flextable objects in an Word file}
\usage{
save_as_docx(..., values = NULL, path)
}
\arguments{
\item{...}{flextable objects, objects, possibly named. If named objects, names are
used as titles.}

\item{values}{a list (possibly named), each element is a flextable object. If named objects, names are
used as titles. If provided, argument \code{...} will be ignored.}

\item{path}{Word file to be created}
}
\description{
sugar function to save flextable objects in an Word file.
}
\examples{
ft1 <- flextable( head( iris ) )
tf <- tempfile(fileext = ".docx")
save_as_docx(ft1, path = tf)


ft2 <- flextable( head( mtcars ) )
tf <- tempfile(fileext = ".docx")
save_as_docx(`iris table` = ft1, `mtcars table` = ft2, path = tf)
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{docx_value}()},
\code{\link{format.flextable}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{plot.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()}
}
\concept{flextable print function}
