% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/99_growth_curves.R
\name{fn_lin_logis}
\alias{fn_lin_logis}
\title{Linear-logistic function}
\usage{
fn_lin_logis(t, t1, t2, k)
}
\arguments{
\item{t}{A numeric vector of input values (e.g., time).}

\item{t1}{The onset time of the response. The function is 0 for all values less than \code{t1}.}

\item{t2}{The transition time between the linear and logistic phases. Must be greater than \code{t1}.}

\item{k}{The plateau height. The function transitions toward this value in the logistic phase.}
}
\value{
A numeric vector of the same length as \code{t}, representing the function values.
}
\description{
A piecewise function that models an initial linear increase followed by a logistic saturation.
}
\details{
\if{html}{
\deqn{
f(t; t_1, t_2, k) =
\begin{cases}
0 & \text{if } t < t_1 \\
\dfrac{k}{2(t_2 - t_1)} \cdot (t - t_1) & \text{if } t_1 \leq t \leq t_2 \\
\dfrac{k}{1 + e^{-2(t - t_2) / (t_2 - t_1)}} & \text{if } t > t_2
\end{cases}
}
}

The linear segment rises from 0 starting at \code{t1}, and the logistic segment begins at \code{t2},
smoothly approaching the plateau value \code{k}.
}
\examples{
library(flexFitR)
plot_fn(
  fn = "fn_lin_logis",
  params = c(t1 = 35, t2 = 50, k = 100),
  interval = c(0, 108),
  n_points = 2000,
  auc_label_size = 3
)
}
