% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_numSiblings}
\alias{fxml_numSiblings}
\title{Siblings of an XML element}
\usage{
fxml_numSiblings(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The number of siblings of the XML element with ID \code{elemid}.
}
\description{
Determines the number of siblings of an XML element, i.e. elements on the same hierarchical level.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Determine the number of siblings (elements on the same hierarchy level) of the XML element
# with ID 4 (xml.dataframe$elemid. ==  4)
fxml_numSiblings(xml.dataframe, 4)
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}

#' @seealso \code{\link{fxml_hasSiblings}}, \code{\link{fxml_getSiblings}}
}
