% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getElementInfo}
\alias{fxml_getElementInfo}
\title{Handling flat XML files}
\usage{
fxml_getElementInfo(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
A list with the following elements:
\itemize{
\item \code{value}: The value of the XML element; return value of the \code{\link{fxml_getValue}} function.
\item \code{path}: A vector representing the path from the root element of the XML element document to the current element. Each XML element on the path is represented by a element of the vector. The vector elements are the names of the XML elements on the path.
\item \code{depth.level}: The depth level (hierarchy level) of the XML element; return value of the \code{\link{fxml_getDepthLevel}} function.
\item \code{attributes}: A named vector with the attributes of the XML element (vector elements are the attributes' values, names of the vector elements are the attributes' names; return value of the \code{\link{fxml_getAttributesAll}} function.
\item \code{parent}: The parent of the XML element; return value of the \code{\link{fxml_getParent}} function.
\item \code{children}: The children of the XML element; return value of the \code{\link{fxml_getChildren}} function.
\item \code{siblings}: The siblings of the XML element; return value of the \code{\link{fxml_getSiblings}} function.
}
}
\description{
Returns summary information on an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Get all relevant information on the XML element with ID 4 (xml.dataframe$elemid. ==  4)
fxml_getElementInfo(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_getElement}}, \code{\link{fxml_getValue}}, \code{\link{fxml_getDepthLevel}}, \code{\link{fxml_getAttribute}}, \code{\link{fxml_getChildren}}, \code{\link{fxml_getParent}}, \code{\link{fxml_getSiblings}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
