% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_getElement}
\alias{fxml_getElement}
\title{Handling flat XML files}
\usage{
fxml_getElement(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
Name of the element identified by the ID (\code{xmlflat.df$elemid.}) \code{elemid}.
}
\description{
Returns the element name of an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Get the XML element with ID 3 (xml.dataframe$elemid. ==  3)
fxml_getElement(xml.dataframe, 3)
}
\seealso{
\code{\link{fxml_getUniqueElements}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
