% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatxml.r
\name{fxml_numChildren}
\alias{fxml_numChildren}
\title{Children of an XML element}
\usage{
fxml_numChildren(xmlflat.df, elemid)
}
\arguments{
\item{xmlflat.df}{A flat XML dataframe created with \code{\link{fxml_importXMLFlat}}.}

\item{elemid}{The ID of the XML element. The ID is the value of the \code{elemid.} field in the flat XML dataframe.}
}
\value{
The number of children of the XML element with ID \code{elemid}.
}
\description{
Determines the number of children of an XML element.
}
\examples{
# Load example file with population data from United Nations Statistics Division
# and create flat dataframe
example <- system.file("worldpopulation.xml", package="flatxml")
xml.dataframe <- fxml_importXMLFlat(example)

# Determine the number of children (sub-elements) of the XML element with ID 4
# (xml.dataframe$elemid. ==  4)
fxml_numChildren(xml.dataframe, 4)
}
\seealso{
\code{\link{fxml_hasChildren}}, \code{\link{fxml_getChildren}}
}
\author{
Joachim Zuckarelli \email{joachim@zuckarelli.de}
}
