% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{remove_bottom}
\alias{remove_bottom}
\alias{remove_bottom.pivot_table}
\title{Remove bottom rows from a pivot table}
\usage{
remove_bottom(pt, n)

\method{remove_bottom}{pivot_table}(pt, n)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{n}{A number, number of rows to remove.}
}
\value{
A \code{pivot_table} object.
}
\description{
Remove bottom rows from the pivot table represented by the object.
}
\details{
A pivot table should only contain label rows and columns, and an array of
values, usually numeric data.

All rows not belonging to the pivot table must be removed. It is common to
find rows with footer information, which must be removed.

This function is very useful because it is not necessary to know the number
of rows in the table.
}
\examples{

pt <- pt_ex |> remove_bottom(3)

}
\seealso{
\code{\link{pivot_table}}

Other pivot table transformation functions: 
\code{\link{extract_labels}()},
\code{\link{fill_labels}()},
\code{\link{fill_values}()},
\code{\link{remove_agg}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_k}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{replace_dec}()},
\code{\link{unpivot}()}
}
\concept{pivot table transformation functions}
