% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table.R
\name{set_page}
\alias{set_page}
\alias{set_page.pivot_table}
\title{Set page information to a pivot table}
\usage{
set_page(pt, row, col, page)

\method{set_page}{pivot_table}(pt, row = 0, col = 0, page = "")
}
\arguments{
\item{pt}{A \code{pivot_table} object.}

\item{row, col}{A cell (row and column number), page information included in
the table.}

\item{page}{A string, page information.}
}
\value{
A \code{pivot_table} object.
}
\description{
Define the page information associated with a pivot table. Previously
existing information is replaced by new information.
}
\details{
Each pivot table implements a report. The pivot table page represents the
context of that report. It is useful when we work with several pivot tables
with the same structure: for example, the page can allow us to differentiate
their origin, date or author. This information is often included in the file
name, sheet name, or a cell attached to the pivot table.
}
\examples{

pt <- pt_ex |> set_page(1, 1)

pt <- pt_ex |> set_page(page = "M4")

}
\seealso{
\code{\link{pivot_table}}

Other pivot table definition functions: 
\code{\link{define_labels}()},
\code{\link{get_page}()},
\code{\link{pivot_table}()}
}
\concept{pivot table definition functions}
