% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pivot_table_page.R
\name{get_page}
\alias{get_page}
\alias{get_page.pivot_table}
\title{Get the page information of a pivot table}
\usage{
get_page(pt)

\method{get_page}{pivot_table}(pt)
}
\arguments{
\item{pt}{A \code{pivot_table} object.}
}
\value{
A vector of strings.
}
\description{
Get the page information associated with the pivot table represented by the
object.
}
\details{
Each pivot table implements a report. The pivot table page represents the
context of that report. It is useful when we work with several pivot tables
with the same structure: for example, the page can allow us to differentiate
their origin, date or author. This information is often included in the file
name, sheet name, or cells attached to the pivot table.
}
\examples{
page <- get_page(pt_m4)

}
\seealso{


Other pivot table definition functions: 
\code{\link{define_labels}()},
\code{\link{divide}()},
\code{\link{remove_bottom}()},
\code{\link{remove_cols}()},
\code{\link{remove_empty}()},
\code{\link{remove_left}()},
\code{\link{remove_right}()},
\code{\link{remove_rows}()},
\code{\link{remove_top}()},
\code{\link{set_page}()},
\code{\link{view_table_attr}()}
}
\concept{pivot table definition functions}
