% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MiscFuns.R
\name{dof}
\alias{dof}
\title{Type of degree of freedom in fixest summary}
\usage{
dof(fixef = "nested", exact = FALSE, cluster = TRUE)
}
\arguments{
\item{fixef}{How to account for the fixed-effects parameters, defaults to \code{"nested"}. If \code{FALSE} or \code{"no"}, fixed-effects parameters are discarded, meaning the number of parameters is only equal to the number of variables. If \code{TRUE} or \code{yes}, then the number of parameters is equal to the number of variables plus the number of fixed-effects. Finally, if \code{nested}, then the number of parameters is equal to the number of variables an the number of fixed-effects that *are not* nested in the clusters used to cluster the standard-errors.}

\item{exact}{Logical, default is \code{FALSE}. If there are 2 or more fixed-effects, these fixed-effects they can be irregular, meaning they can provide the same information. If so, the "real" number of parameters should be lower than the total number of fixed-effects. If \code{exact = TRUE}, then \code{\link[fixest]{fixef.fixest}} is first run to determine the exact number of parameters among the fixed-effects. Mostly, panels of the type individual-firm-year require \code{exact = TRUE} (but it adds computational costs).}

\item{cluster}{Logical, default is \code{TRUE}. How to make the small sample correction when clustering the standard-errors? If \code{TRUE} a \code{G/(G-1)} correction is performed with \code{G} the number of cluster values.}
}
\value{
It returns a \code{dof.type} object.
}
\description{
Provides how the degrees of freedom should be calculated in \code{\link[fixest]{vcov.fixest}}/\code{\link[fixest]{summary.fixest}}.
}
\examples{

# We create "irregular" FEs
base = data.frame(x = rnorm(10))
base$y = base$x + rnorm(10)
base$fe1 = rep(1:3, c(4, 3, 3))
base$fe2 = rep(1:5, each = 2)

est = feols(y ~ x | fe1 + fe2, base)

# fe1: 3 FEs
# fe2: 5 FEs

#
# Clustered standard-errors: by fe1
#

# Default: fixef = "nested"
#  => adjustment K = 1 + 5 (i.e. x + fe2)
summary(est)
attributes(vcov(est))[c("dof.type", "dof.K")]


# fixef = FALSE
#  => adjustment K = 1 (i.e. only x)
summary(est, dof = dof(fixef=FALSE))
attr(vcov(est, dof = dof(fixef=FALSE)), "dof.K")


# fixef = TRUE
#  => adjustment K = 1 + 3 + 5 - 1 (i.e. x + fe1 + fe2 - 1 restriction)
summary(est, dof = dof(fixef=TRUE))
attr(vcov(est, dof = dof(fixef=TRUE)), "dof.K")


# fixef = TRUE & exact = TRUE
#  => adjustment K = 1 + 3 + 5 - 2 (i.e. x + fe1 + fe2 - 2 restrictions)
summary(est, dof = dof(fixef=TRUE, exact = TRUE))
attr(vcov(est, dof = dof(fixef=TRUE, exact = TRUE)), "dof.K")

# There are two restrictions:
attr(fixef(est), "references")


}
\seealso{
\code{\link[fixest]{summary.fixest}}, \code{\link[fixest]{vcov.fixest}}, \code{\link[fixest]{setFixest_dof}}
}
\author{
Laurent Berge
}
