% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods.R
\name{hatvalues.fixest}
\alias{hatvalues.fixest}
\title{Hat values for \code{fixest} objects}
\usage{
\method{hatvalues}{fixest}(model, ...)
}
\arguments{
\item{model}{A fixest object. For instance from feols or feglm.}

\item{...}{Not currently used.}
}
\value{
Returns a vector of the same length as the number of observations used in the estimation.
}
\description{
Computes the hat values for \code{\link[fixest]{feols}} or \code{\link[fixest]{feglm}} estimations. Only works when there are no fixed-effects.
}
\details{
Hat values are not available for \code{\link[fixest:femlm]{fenegbin}}, \code{\link[fixest]{femlm}} and \code{\link[fixest]{feNmlm}} estimations.

When there are fixed-effects, the hat values of the reduced form are different from the hat values of the full model. And we cannot get costlessly the hat values of the full model from the reduced form. It would require to reestimate the model with the fixed-effects as regular variables.
}
\examples{

est = feols(Petal.Length ~ Petal.Width + Sepal.Width, iris)
head(hatvalues(est))


}
