% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch-coaches-votes.R
\name{fetch_coaches_votes}
\alias{fetch_coaches_votes}
\title{Fetch Coaches Votes}
\usage{
fetch_coaches_votes(
  season = NULL,
  round_number = NULL,
  comp = "AFLM",
  team = NULL
)
}
\arguments{
\item{season}{Season in YYYY format. This can be an array of seasons. Defaults to null in which case the
season that matches \code{Sys.Date()} is used.}

\item{round_number}{Round number. For finals this is the number of H&A rounds plus the Finals week. Defaults to null
in which case all rounds are used.}

\item{comp}{One of "AFLM" (default) or "AFLW"}

\item{team}{Team or teams whose matches should be retrieved. Defaults to null in which case all teams are used.}
}
\value{
A data frame with columns: Season, Round, Finals, Home.Team, Away.Team, Player.Name, Coaches.Votes
}
\description{
\code{fetch_coaches_votes} returns all coaches votes for input season/s, round/s, and/or team's matches.
The function calls a core \code{scrape_coaches_votes} function which scrapes the AFLCA website for coaches votes
for a particular season, round and competition.
}
\examples{
\dontrun{
# Return all coaches votes across all seasons
fetch_coaches_votes(season = 2007:2021, comp = "AFLM")
fetch_coaches_votes(season = 2018:2021, comp = "AFLW")

# Return all coaches votes for a particular round
fetch_coaches_votes(season = 2021, round_number = 24, comp = "AFLM")
fetch_coaches_votes(season = 2021, round_number = 9, comp = "AFLW")

# Return all coaches votes for a particular team
fetch_coaches_votes(season = 2021, comp = "AFLM", team = "Western Bulldogs")
fetch_coaches_votes(season = 2021, comp = "AFLW", team = "Western Bulldogs")

# Return all coaches votes for a particular match
fetch_coaches_votes(season = 2021, round_number = 24, comp = "AFLM", team = "Western Bulldogs")
fetch_coaches_votes(season = 2021, round_number = 9, comp = "AFLW", team = "Western Bulldogs")
}

}
