% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_coaches_vote_possibilities.R
\name{calculate_coaches_vote_possibilities}
\alias{calculate_coaches_vote_possibilities}
\title{Calculate Coaches Vote Possibilities}
\usage{
calculate_coaches_vote_possibilities(df, output_type)
}
\arguments{
\item{df}{Requires the following column names: Player.Name, Coaches.Votes. These can be returned from the
function \code{fetch_coaches_votes}.}

\item{output_type}{One of "Coach View", "Player View". Defaults to "Coach View".}
}
\value{
Data frame
For output_type "Coach View" - A list of data frames with columns: Votes, C1, C2
For output_type "Player View" - A list of data frames with columns: Player, V1, V2
}
\description{
\code{calculate_coaches_vote_possibilities} returns all possible breakdowns of coaches votes between two coaches,
given a breakdown of AFLCA coaches votes
}
\examples{
\dontrun{
# Return coaches votes for a particular match, then find the possibilities
df <- fetch_coaches_votes(comp = "AFLM", season = 2021, round = 24, team = "Western Bulldogs")
calculate_coaches_vote_possibilities(df, "Coach View")

df <- fetch_coaches_votes(comp = "AFLW", season = 2021, round = 9, team = "Western Bulldogs")
calculate_coaches_vote_possibilities(df, "Player View")

# Create a manual data frame to calculate possibilities
df <- data.frame(
  Player.Name = c(
    "Tom Liberatore", "Jack Macrae",
    "Marcus Bontempelli", "Cody Weightman",
    "Darcy Parish", "Aaron Naughton", "Jordan Ridley"
  ),
  Coaches.Votes = c(7, 6, 5, 5, 4, 2, 1)
)
calculate_coaches_vote_possibilities(df, "Player View")
}

}
