% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{fisheye}
\alias{fisheye}
\title{fisheye}
\usage{
fisheye(x, centre, method = "log", k = 1)
}
\arguments{
\item{x}{an sf object (POINT, LINESTRING, MULTILINESTRING, POLYGON,
MULTIPOLYGON) to be transformed. This object needs to be projected
(no lon/lat).}

\item{centre}{an sf object, the center of the transformation. This object
must use the same projection as x.}

\item{method}{transfomation method, either 'log' or 'sqrt'. See Details.}

\item{k}{integer, factor to adjust the log transformation, higher values
soften the deformation. See Details.}
}
\value{
A transformed sf object is returned.
}
\description{
This function transform an sf layer with a fisheye
transformation. Several methods are available. This is a visualisation
method that should not be used for geospatial calculation (area,
distances...).
The output sf object has no CRS as it is not relevant.
}
\details{
The 'log' method transforms distances to \code{center} with:
\eqn{{d}' = \log(1 + 10^{-k} * d)}{%
 d' = log(1 + 10^(-k) * d)}
\cr
The 'sqrt' method transforms distances to \code{center} with:
 \eqn{{d}' = \sqrt(d)}{%
 d' = sqrt(d)}
}
\examples{
library(sf)
ncraw <- st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)
nc <- st_transform(ncraw, 3857)
ncfe <- fisheye(nc, centre = nc[100, ], method = 'log', k = 4)
plot(st_geometry(ncfe), col = "grey70", lwd = .2)
plot(st_geometry(ncfe[100,]), col = NA, lwd = 2, border = "red", add = TRUE)
}
