% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fish.R
\name{fish}
\alias{fish}
\title{Send a query request for data}
\usage{
fish(bait, sql = NULL)
}
\arguments{
\item{bait}{A 'bait' character scalar (endpoint) prepared via a bait function (e.g. `bait.gfw.effort()`).}

\item{sql}{Optional. A character scalar. Defaults to NULL. Select sql="count" to get the number of entries that the bait would normally return, sql="query" to get the query that will be run on the database.}
}
\value{
The result of your query, usually a dataframe.
}
\description{
Function to 'fish' for data using a 'bait' via fishRman's API.
}
\examples{
\donttest{
bait <- bait.gfw.effort(table = "fishing_effort_byvessel_v2", end_date="2012-01-02")

what_is_the_bait_selecting <- fish(bait = bait, sql = "query")

print(what_is_the_bait_selecting)
# "SELECT * FROM gfw_fishing_effort_byvessel_v2 WHERE dated <= '2012-01-02'"
}

}
\seealso{
[bait.gfw.effort()]
}
