% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df.type.R
\name{df.type}
\alias{df.type}
\title{Check the type of dataframe in relation to fishRman}
\usage{
df.type(df)
}
\arguments{
\item{df}{The dataframe to check.}
}
\value{
A string explaining how the input dataframe is treated by fishRman.
}
\description{
Function to check the type of dataframe in relation to fishRman. Most of the times the user will not call this function directly, but it can be useful for debug.
}
\examples{

dated <- c("2020-01-01", "2020-01-02")
lat <- c(40, 41)
lon <- c(12,13)
mmsi <- c("34534555", "25634555")
hours <- c(0, 5)
fishing_hours <- c(1,2)

df <- data.frame(dated, lat, lon, mmsi, hours, fishing_hours)

what.type <- df.type(df)

print(what.type)

# "GFW Fishing Effort By Vessel"
}
\seealso{
[bait.gfw.effort()] [fish()]
}
