% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_function.R
\name{waf}
\alias{waf}
\title{Calculated wind adjustment factor}
\usage{
waf(fuelDepth, forestHt, cr, cc, sheltered = "n")
}
\arguments{
\item{fuelDepth}{a numeric vector of surface fuel bed depths (cm)}

\item{forestHt}{a numeric vector of average stand tree heights (m)}

\item{cr}{a numeric vector of crown ratios (\%)}

\item{cc}{a numeric vector of canopy cover (\%)}

\item{sheltered}{a character vector of either \code{"y"} or \code{"n"} (default) to use sheltered or not (unsheltered) equations}
}
\value{
a vector of wind adjustment factors
}
\description{
Prediction of wind adjustment factor for sheltered and unsheltered fuels.
}
\details{
This calculates the wind adjustment factor (ratio of 20-ft open wind speed to wind speed at midflame height of a surface fire).
One of two equations are used, depending on user input: by default, this function assumes the surface fuel bed is unsheltered.
\code{fuelDepth} must be a positive value if the unsheltered variant is invoked. \cr
There are two conditions to enable calculation for a sheltered fuelbed. One, the product of \code{cr} and
\code{cc} must exceed 5\%. Alternatively, if \code{cr} and \code{cc} are not supplied, the user may enter \code{"sheltered = y"}.
The former method is recommended when \code{cr} and \code{cc} are known. In addition, either means of invoking the sheltered equation must also have \code{forestHt} provided.
}
\examples{
#Sheltered fuelbed with a 10 m tall forest with unknown crown ratio and canopy cover
waf(forestHt = 10, sheltered = 'y')
#Sheltered fuelbed with known high crown ratio and canopy cover
waf(forestHt = 10, cr = 40, cc = 40)
#Sheltered fuelbed with known low crown ratio and canopy cover
waf(fuelDepth = 1, forestHt = 10, cr = 10, cc = 10)
#Because cr and cc are low, the previous solution is equivalent to an unsheltered fuelbed
waf(fuelDepth = 1)
}
\references{
Andrews, P.L. 2012. Modeling wind adjustment factor and midflame wind speed for Rothermel’s surface fire spread model. \emph{RMRS-GTR-266}. USDA Forest Service Rocky Mountain Research Station.
}
\author{
Justin P Ziegler, \email{justin.ziegler@colostate.edu}
}
