% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rothermel_function.R
\name{rothermel}
\alias{rothermel}
\title{Rothermel Fire Behavior Modeling System}
\usage{
rothermel(surfFuel, moisture, crownFuel, enviro, rosMult = 1,
  cfbForm = "f", folMoist = "y")
}
\arguments{
\item{surfFuel}{a data frame of surface fuel attributes. Variable names
are not important but the order is important. The first variable is a character type
whereas the rest are numeric
\enumerate{
  \item the fuel model type, either 'S'tatic or D'ynamic herb load transfer
  \item litter load (Mg/ha)
  \item 1-hr load (Mg/ha)
  \item 10-hr load (Mg/ha)
  \item 100-hr load (Mg/ha)
  \item herb load (Mg/ha)
  \item woody load (Mg/ha)
  \item litter SAV (m2/m3)
  \item 1-hr SAV (m2/m3)
  \item 10-hr SAV (m2/m3)
  \item 100-hr SAV (m2/m3)
  \item herb SAV (m2/m3)
  \item woody SAV (m2/m3)
  \item fuel bed depth (cm)
  \item moisture of extinction (\%)
  \item heat content (J/g)
  }}

\item{moisture}{a numeric-only data frame of surface fuel moistures on a dry-weight basis
(\%). Variable names are not important but the following order of surface fuel
components is important: litter, 1-hr woody fuels, 10-hr woody fuels, 100-hr woody fuels,
live herbaceous, and live woody vegetation (6 values or columns)}

\item{crownFuel}{a vector or data frame with canopy fuel attributes, in order:
\enumerate{
  \item canopy bulk density (kg/m3)
  \item foliar moisture content (\%)
  \item canopy base height (m)
  \item canopy fuel load (kg/m2)
  }}

\item{enviro}{a numeric-only data frame with environmental attributes, in order:
\enumerate{
 \item topographic slope (\%)
 \item open windspeed (km/hr)
 \item wind direction, from uphill (deg.)
 \item wind adjustment factor (0-1)
 }}

\item{rosMult}{a numeric value for multiplying crown fire rate of spread, defaults to 1 (see details)}

\item{cfbForm}{a character specifying how crown fraction burned is calculated.
Options are \code{"sr"}, \code{"w"}, or \code{"f"} (default); see details.}

\item{folMoist}{either \code{"y"} (default) or \code{"n"}, specifying if foliar moisture effect is calculated (see details)}
}
\value{
a list with 6 data frames
\item{fireBehavior}{a data frame with fire behavior estimates including fire type, crown fraction
burned (\%), rate of spread (m/min), heat per unit area (kJ/m2), fireline intensity (kW/m), flame
length (m), direction of max spread (deg), scorch height (m), torching index (km/hr), crowning
index (km/hr), surfacing index (km/hr), effective midflame wind (km/hr), flame residence time (min) }
\item{detailSurface}{a data frame with some intermediate variables of surface fire behavior
including: potential ROS (m/min); no wind, no slope ROS (m/min); slope factor (-); wind factor (-);
characteristic dead fuel moisture (\%); characteristic live fuel moisture (\%); characteristic SAV
(m2/m3); bulk density (kg/m3); packing ratio (-); relative packing ratio (-); reaction intensity
(kW/m2); heat source (kW/m2); heat sink (kJ/m3)}
\item{detailCrown}{a data frame with some intermediate variables of crown fire behavior including:
potential ROS (m/min); no wind, no slope ROS (m/min); slope factor (-); wind factor (-);
characteristic dead fuel moisture (\%); characteristic live fuel moisture (\%); characteristic SAV
(m2/m3); bulk density (kg/m3); packing ratio (-); relative packing ratio (-); reaction intensity
(kW/m2); heat source (kW/m2); heat sink (kJ/m3)}
\item{critInit}{a data frame of critical values for crown fire initiation including: fireline
intensity (kW/m), flame length (m), surface ROS (m/min), Canopy base height (m)}
\item{critActive}{a data frame of critical values for active crown fire  including: canopy bulk
density (kg/m3)", "ROS, crown (R'active) (m/min)}
\item{critCess}{a data frame of critical values for cessation of crown fire including: canopy base
height (m), O'cessation (km/hr)}
}
\description{
Potential surface and crown fire behavior predicted by Scott and Reinhardt (2001).
}
\details{
This in an R build of the Rothermel fire behavior modelling system (Scott & Reinhardt 2001)
which links sub-models of surface fire rate of spread (Rothermel 1972), crown fire initiation
(Van Wagner 1977), and Rothermel's (1991) crown fire rate of spread. \cr
\code{rosMult} multiples the rate of spread for active or passive crown fires and is recommended
 a value of 1.7 when a user desires a maximum crown fire rate of spread (Rothermel 1991). \cr
\code{cfbForm} selects the method to estimate crown fraction burned. This selection impacts estimates
of passive crown fraction burned, fireline intensity, and heat per unit area. Use "sr" for Scott
and Reinhardt (2001), "w" for van Wagner (1993), and "f" for Finney (1998).\cr
\code{folMoist}, if invoked with a \code{"y"}, calculates the foliar moisture effect to scale crown
fire rate of spread (see Scott & Reinhardt 2001). If \code{"n"}, no foliar moisture effect is determined.
}
\examples{
data(fuelModels, fuelMoisture)
#fuelModels['A10',]
exampSurfFuel = fuelModels['A10',]

#fuelMoisture['D1L1',]
exampFuelMoisture = fuelMoisture['D1L1',]

exampCrownFuel = data.frame(
 CBD = coForest$cbd_kgm3[1],
 FMC = 100,
 CBH = coForest$cbh_m[1],
 CFL = coForest$cfl_kgm2[1]
)

exampEnviro = data.frame(
 slope = 10,
 windspeed = 40,
 direction = 0,
 waf = 0.2
)
rothermel(exampSurfFuel, exampFuelMoisture, exampCrownFuel, exampEnviro)
}
\references{
Rothermel, R.C. 1972. A mathematical model for predicting fire spread in wildland fuels.
\emph{INT-RP-115}. USDA Forest Service Intermountain Forest & Range Experimental Station.\cr
Van Wagner, C.E. 1977. Conditions for the start and spread of crown fire. \emph{Canadian Journal of
Forest Research} \strong{7}:23–34.\cr
Rothermel, R.C., 1991. Predicting behavior and size of crown fires in the northern Rocky Mountains.
 \emph{INT-RP-438}. USDA Forest Service Intermountain Research Station.\cr
Van Wagner, C.E. 1993. Prediction of crown fire behavior in two stands of jack pine.
\emph{Canadian Journal of Forest Research} \strong{23}:442–449.\cr
Finney, M.A. 1998. FARSITE: Fire area simulator — model development and evaluation.
\emph{RMRS-RP-47}. USDA Forest Service Rocky Mountain Research Station. \cr
Scott, J.H., Reinhardt, E.D. 2001. Assessing crown fire potential by linking models of surface and
crown fire behavior. \emph{RMRS-RP-29}. USDA Forest Service Rocky Mountain Research Station.\cr
}
\author{
Justin P Ziegler, \email{justin.ziegler@colostate.edu}
}
