% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finnishgrid.R
\name{production_imbalance_electricity_buying_price}
\alias{production_imbalance_electricity_buying_price}
\title{The buying price of production imbalance electricity}
\usage{
production_imbalance_electricity_buying_price(
  start_time = NA,
  end_time = NA,
  user_key = NA
)
}
\arguments{
\item{start_time}{Start time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{end_time}{End time in UTC with offset. Character array in ISO8601,
YYYY-MM-ddTHH:mm:ssZ}

\item{user_key}{Character array holding API-key.
Free from https://data.fingrid.fi/open-data-forms/registration/}
}
\value{
A data frame object that contains the down-regulating price of the
hour is the price of production imbalance power purchased by Fingrid
from a balance responsible party. If no down-regulation has been made
or if the hour has been defined as an up-regulation hour, the Elspot
FIN price is used as the purchase price of production imbalance power.
Separate production balance ended when 1.11.2021 01.00 setllement model
was changed to single imbalance.
}
\description{
Check https://data.fingrid.fi/en/dataset/the-bying-price-of-production-imbalance-electricity
}
\examples{
\dontrun{
library(finnishgrid)
start = "2021-01-01T00:00:00+0200"  # UTC+2 offset, Helsinki time
end = "2021-01-10T00:00:00+0200"    # UTC+2 offset, Helsinki time
key = "MY_SUPER_SECRET"
df <- production_imbalance_electricity_buying_price(start_time = start,
    end_time = end,
    user_key = key)
summary(df)
}
}
