% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finbif_taxa.R
\name{finbif_taxa}
\alias{finbif_taxa}
\alias{fb_taxa}
\title{Search the FinBIF taxa}
\usage{
finbif_taxa(
  name,
  n = 1,
  type = c("exact", "partial", "likely"),
  cache = getOption("finbif_use_cache")
)
}
\arguments{
\item{name}{Character. The name of a taxon to search for.}

\item{n}{Integer. Maximum number of matches to return. For types "exact" and
"likely" a maximum of one taxon will be returned.}

\item{type}{Character. Type of match to make. Must be one of \code{exact},
\code{partial} or \code{likely}.}

\item{cache}{Logical. Use cached data.}
}
\value{
A \code{finbif_api} object.
}
\description{
Search the FinBIF database for taxon.
}
\examples{
\dontrun{

# Search for a taxon
finbif_taxa("Ursus arctos")

# Use partial matching
finbif_taxa("Ursus", n = 10, "partial")
}
}
