% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary_visible.R
\name{aux.rndmissing}
\alias{aux.rndmissing}
\title{Randomly assign NAs to the data matrix with probability \code{x}}
\usage{
aux.rndmissing(A, x = 0.1)
}
\arguments{
\item{A}{an \eqn{(n\times p)} data matrix.}

\item{x}{percentage of turning current entries into missing (\code{NA}).}
}
\value{
an \eqn{(n\times p)} data matrix with missing entries at proportion \eqn{x}.
}
\description{
\code{aux.rndmissing} randomly selects \eqn{100\cdot x}\% of entries from
a given data matrix and turns them into missing entries, i.e., their values
become \code{NA}.
}
\examples{
# load lena64 image matrix
data(lena64)

# generate 10\% of missing values
lena64_miss <- aux.rndmissing(lena64)

# visualize
par(mfrow=c(1,2))
image(lena64, axes=FALSE, main="original image")
image(lena64_miss, axes=FALSE, main="10\% missing entries")

}
