% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_voteview_rollcall_votes.R
\name{get_voteview_rollcall_votes}
\alias{get_voteview_rollcall_votes}
\title{Get data on congressional roll call votes from Voteview}
\usage{
get_voteview_rollcall_votes(
  local = TRUE,
  local_dir = ".",
  chamber = "all",
  congress = NULL
)
}
\arguments{
\item{local}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} Whether to read the data from a local file, as opposed to the Voteview website.
Default is \code{TRUE}. If the local file does not exist, will fall back to reading from Voteview.}

\item{local_dir}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}} The directory containing the local file. Defaults to the working directory.}

\item{chamber}{Which chamber to get data for. Options are:
\itemize{
\item \code{"all"}, \code{"congress"}: Both House and Senate data (the default).
\item \code{"house"}, \code{"h"}, \code{"hr"}: House data only.
\item \code{"senate"}, \code{"s"}, \code{"sen"}: Senate data only.
These options are case-insensitive. If you explicitly pass a different value,
it will default to "all" with a warning.
}}

\item{congress}{A whole number (to get data for a single Congress), or
a numeric vector (to get data for a set of congresses).
Optional; will retrieve data for all Congresses by default.
If specified, Congress numbers cannot be greater than the \code{\link[=current_congress]{current_congress()}}
(i.e., you cannot try to get future data).}
}
\value{
A \code{\link[=tibble]{tibble()}}.
}
\description{
\code{get_voteview_rollcall_votes()} returns a tibble with information on recorded
(roll call) votes in the House and Senate.
}
\details{
See the
\href{https://voteview.com/data}{Voteview} website for more information on their data.

Please cite this dataset as:

Lewis, Jeffrey B., Keith Poole, Howard Rosenthal, Adam Boche, Aaron Rudkin,
and Luke Sonnet (2023). \emph{Voteview: Congressional Roll-Call Votes Database}.
\url{https://voteview.com/}
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
get_voteview_rollcall_votes()

# Force to get data from Voteview website
get_voteview_rollcall_votes(local = FALSE)

# Get data for only one chamber
# NOTE: the President is included in all data
get_voteview_rollcall_votes(chamber = "house")
get_voteview_rollcall_votes(chamber = "senate")
\dontshow{\}) # examplesIf}
# Get data for a specific Congress
get_voteview_rollcall_votes(congress = 100)
get_voteview_rollcall_votes(congress = current_congress())

\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Get data for a set of Congresses
get_voteview_rollcall_votes(congress = 1:10)
\dontshow{\}) # examplesIf}
}
