% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_functions.r
\name{annotate.page}
\alias{annotate.page}
\title{annotate.page}
\usage{
annotate.page(
  page.height = 8.5,
  page.width = 11,
  top.margin = 1 - 0.5,
  bottom.margin = 1 - 0.5,
  right.margin = 0.75,
  left.margin = 0.75,
  foot.size = 10,
  head.size = 10,
  title.size = 14,
  add.fignum = TRUE,
  fnote.buffer = 0,
  header.buffer = 0,
  fignum.buffer = 1,
  title.buffer = 2,
  fignum = "1.100",
  title = list("If ggplot populates title, annotate.page's title argument gets a ",
    "list of whitespace text strings. If annotate.page is populating titles,",
    "use whitespaces and newline escape characters in ggplot titles",
    "to ensure ggplot object is shrunken titles do not stamp over your graphs"),
  ulh = list("Upper Left Header 1", "Upper Left Header 2", "Upper Left Header 3"),
  urh = list("Upper Right Header 1", "Upper Right Header 2", "Upper Right Header 3"),
  fnote = list("Footnote1: Up to five lines of footnotes can be annotated.",
    "Footnote2: Graphic region height can be flexed.", "Footnote3", "Footnote4",
    "Footnote5: In large-scale production, this may hold file name, time stamp, etc."),
  override = "",
  addTime = TRUE
)
}
\arguments{
\item{page.height}{used by build.page and annotate.page; presumed to be inches}

\item{page.width}{used by build.page and annotate.page; presumed to be inches}

\item{top.margin}{used by build.page and annotate.page; presumed to be inches}

\item{bottom.margin}{used by build.page and annotate.page}

\item{right.margin}{used by build.page and annotate.page; presumed to be inches}

\item{left.margin}{used by build.page and annotate.page; presumed to be inches}

\item{foot.size}{default: 10; passed to grid.text via gp (annotate.page)}

\item{head.size}{default: 10 (anotate.page)}

\item{title.size}{default: 14; passed to grid.text via gp (annotate.page)}

\item{add.fignum}{logical (annotate.page)}

\item{fnote.buffer}{fine-control of vertical position (annotate.page)}

\item{header.buffer}{fine-control of vertical position (anotate.page)}

\item{fignum.buffer}{fine-control of vertical position (annotate.page)}

\item{title.buffer}{fine-control of vertical position (annotate.page)}

\item{fignum}{figure number (annotate.page)}

\item{title}{vector of title lines (annotate.page)}

\item{ulh}{vector for upper left headers (annotate.page)}

\item{urh}{vector for upper right headers (annotate.page)}

\item{fnote}{vector of 5 footnotes. 5th row is traditionally reserved for filepath, table reference and time stamp. Populate from bottom up. (annotate.page)}

\item{override}{override}

\item{addTime}{logical for ading time stamp (annotate.page)}
}
\value{
Following an application of build.page, this function stamps on meta-data.
}
\description{
Optionally adds up to 4 lines for titles, 3 lines for right and left headers, and 5 lines of footnotes
}
\author{
Greg Cicconetti
}
