#' Data from Silverman et al. (2018) Microbiome
#' 
#' High Resolution (hourly and daily) sampling of 4 in vitro artificial gut models
#' with many technical replicates to identify technical variation. 
#' 
#' This data is at the sequence variant level. Data at the family level
#' processed as in Silverman et al. 2018 is given in \code{\link{mallard_family}}
#' 
#' @docType data
#' @name mallard
#' @usage data(mallard)
#' @format A list containing "otu_table", "sample_data", "tax_table", and "refseq".
#' @references Silverman et al. "Dynamic linear models guide design and 
#'   analysis of microbiota studies within artificial human guts". 
#'   Microbiome 2018 6:202
NULL