% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.fic.R
\name{ggplot_fic}
\alias{ggplot_fic}
\title{Plot focused model comparison statistics: ggplot2 method}
\usage{
ggplot_fic(x, ci = TRUE, legend = TRUE, ylab = NULL, xlab = NULL,
  xlim = NULL, ylim = NULL)
}
\arguments{
\item{x}{Output from \code{\link{fic}}.}

\item{ci}{Plot interval estimates? (\code{TRUE} or \code{FALSE}).  These are calculated as plus / minus twice the standard error of the submodel focus under the wide model.  These are rough estimates of uncertainty intended to illustrate the bias-variance tradeoff, and exclude any uncertainty associated with the choice between models.}

\item{legend}{Show a legend, identifying

a) the line types for the wide and narrow models

b) the names of the terms of the wide model.  This is used when
the \code{inds} object supplied to \code{\link{fic}} was constructed by
\code{\link{all_inds}}, so has row names made out of a string
of 0s and 1s that identify the terms included in the submodel.
These strings are plotted as text labels against the estimate for
each submodel.  The legend identifies which 0s and 1s correspond
to which model terms.}

\item{ylab}{y-axis label.}

\item{xlab}{x-axis label.}

\item{xlim}{x-axis limits (pair of numbers)}

\item{ylim}{y-axis limits}
}
\description{
This only works if the focus estimates are available. The focus estimates are
plotted against the root MSE.  One plot is made for each covariate
value defining different focuses.  If the wide model estimate is
available, this is illustrated as a solid line on the plot, and if
the narrow model estimate is available, this is showm as a dashed
line.
}
\examples{

## Example from the main vignette, see there for more details

wide.glm <- glm(low ~ lwtkg + age + smoke + ht + ui + smokeage + smokeui,
                data=birthwt, family=binomial)
vals.smoke <-    c(1, 58.24, 22.95, 1, 0, 0, 22.95, 0)
vals.nonsmoke <- c(1, 59.50, 23.43, 0, 0, 0, 0, 0)
X <- rbind("Smokers" = vals.smoke, "Non-smokers" = vals.nonsmoke)
inds0 <- c(1,1,0,0,0,0,0,0)
combs <- all_inds(wide.glm, inds0)
ficres <- fic(wide = wide.glm, inds = combs, inds0 = inds0,
              focus = prob_logistic, X = X)
ggplot_fic(ficres)
summary(ficres)

}
\seealso{
plot.fic, summary.fic
}
