context("test-read_fgd_dem")

test_that("Successed on dummies", {
  res <-
    read_fgd_dem(file = system.file("extdata/FG-GML-0000-00-00-DEM5A-dummy.xml",
                                    package = "fgdr"),
                 resolution = 5)
  expect_is(res, "data.frame")
  expect_identical(as.character(res[1, 1]),
                   paste(intToUtf8(c(12381, 12398, 20182), multiple = TRUE), collapse = ""))
  expect_s3_class(res, "tbl_df")
  expect_equal(dim(res), c(33750, 2))
  expect_named(res, c("type", "value"))

  res <-
    read_fgd_dem(system.file("extdata/FG-GML-0000-00-00-DEM5A-dummy.xml",
                             package = "fgdr"),
                 resolution = 5,
                 return_class = "raster")
  expect_s4_class(res, "RasterLayer")
  expect_equal(unique(raster::getValues(res)), c(-9999L, NA_real_))

  res <-
    read_fgd_dem(system.file("extdata/FG-GML-0000-10-dem10b-dummy.xml",
                             package = "fgdr"),
                 resolution = 10)
  expect_is(res, "data.frame")
  expect_s3_class(res, "tbl_df")
  expect_equal(dim(res), c(843750, 2))
  expect_named(res, c("type", "value"))
  expect_equal(unique(res$value), c(-9999L, NA_real_))

})
