% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demo.R
\name{demo_ffstream}
\alias{demo_ffstream}
\title{Demo for ffstream}
\usage{
demo_ffstream(showPlot = FALSE, returnStream = FALSE, plotSmall = FALSE)
}
\arguments{
\item{showPlot}{Boolean flag; if \code{TRUE}, then a plot is generated.
Default is \code{FALSE}.}

\item{returnStream}{Boolean flag; if \code{TRUE}, then return the stream 
as part of the list returned by the demo.
Default is \code{FALSE}.}

\item{plotSmall}{Boolean flag; if \code{TRUE}, creates a small plot, as
needed for the vignette. Default is \code{FALSE}.}
}
\value{
Print output to screen, and plot (optional).
}
\description{
Provides a demonstration of the AFF method detecting changepoints in a 
stream.
}
\details{
This method generates a stream with three changepoints, and finds 
         the changepoints with AFF. Also creates a plot of the data and 
         the changepoints if the \code{showPlot} flag is set to \code{TRUE}.
         The observations are shown in black, the true changepoints are
         shown as red dotted vertical lines, and the detected (estimated)
         changepoints are shown as blue dashed lines. The following is 
         returned in a list:
         \describe{
                   \item{tau}{The location of the true changepoints.}

                   \item{tauhat}{The detected (estimated) changepoints.}

                   \item{method}{The method used, in this case AFF.}

                   \item{param}{The data frame with the parameters used in 
                                the AFF method, in this case, 
                         \describe{
                                   \item{alpha}{The significance level,}

                                   \item{eta}{The step size in the 
                                              gradient descent, whose
                                              value is not particularly
                                              important,}

                                   \item{BL}{The length of the burn-in
                                             period.}


                                  }
                                }
                  }
}
\section{Author}{

Dean Bodenham
}

\section{References}{

D. A. Bodenham and N. M. Adams (2016) 
\emph{Continuous monitoring for changepoints in data 
streams using adaptive estimation}. 
Statistics and Computing  
doi:10.1007/s11222-016-9684-8
}

\examples{
df <- demo_ffstream()

\donttest{
demo_ffstream(showPlot=TRUE)
}


}
