% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/0_generics.R, R/espn_draft.R, R/flea_draft.R,
%   R/mfl_draft.R, R/sleeper_draft.R
\name{ff_draft}
\alias{ff_draft}
\alias{ff_draft.espn_conn}
\alias{ff_draft.flea_conn}
\alias{ff_draft.mfl_conn}
\alias{ff_draft.sleeper_conn}
\title{Get Draft Results}
\usage{
ff_draft(conn, ...)

\method{ff_draft}{espn_conn}(conn, ...)

\method{ff_draft}{flea_conn}(conn, ...)

\method{ff_draft}{mfl_conn}(conn, custom_players = deprecated(), ...)

\method{ff_draft}{sleeper_conn}(conn, ...)
}
\arguments{
\item{conn}{a conn object created by \code{ff_connect()}}

\item{...}{args for other methods}

\item{custom_players}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} - now returns custom players by default}
}
\value{
A tidy dataframe of draft results
}
\description{
This function gets a tidy dataframe of draft results for the current year.
Can handle MFL devy drafts or startup drafts by specifying the custom_players argument
}
\section{Methods (by class)}{
\itemize{
\item \code{espn_conn}: ESPN: returns the current year's draft/auction, including details on keepers

\item \code{flea_conn}: Fleaflicker: returns a table of drafts for the current year

\item \code{mfl_conn}: MFL: returns a table of drafts for the current year - can handle devy/startup-rookie-picks by specifying custom_players (slower!)

\item \code{sleeper_conn}: Sleeper: returns a dataframe of all drafts and draft selections, if available.
}}

\examples{
\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- espn_connect(season = 2020, league_id = 899513)
  ff_draft(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  conn <- fleaflicker_connect(season = 2020, league_id = 206154)
  ff_draft(conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
  ssb_conn <- ff_connect(platform = "mfl", league_id = 54040, season = 2020)
  ff_draft(ssb_conn)
}) # end try
}

\donttest{
try({ # try only shown here because sometimes CRAN checks are weird
jml_conn <- ff_connect(platform = "sleeper", league_id = "522458773317046272", season = 2020)
ff_draft(jml_conn)
}) # end try
}

}
