% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{league_messages}
\alias{league_messages}
\title{Fantasy league teams}
\usage{
league_messages(leagueId = ffl_id(), leagueHistory = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}. Arguments are
converted to a named list and passed to \code{query} alongside \code{view}.}
}
\value{
A tibble of messages.
}
\description{
The emails, chats, notes, and messages sent by league members.
}
\examples{
league_messages(leagueId = "42654852")
}
\seealso{
Other league functions: 
\code{\link{draft_recap}()},
\code{\link{league_members}()},
\code{\link{league_standings}()},
\code{\link{league_status}()},
\code{\link{league_teams}()},
\code{\link{tidy_schedule}()},
\code{\link{transaction_counter}()}
}
\concept{league functions}
