% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/settings.R
\name{scoring_settings}
\alias{scoring_settings}
\title{League scoring settings}
\usage{
scoring_settings(leagueId = ffl_id(), leagueHistory = FALSE, ...)
}
\arguments{
\item{leagueId}{Numeric league ID or ESPN fantasy page URL. Defaults to
\code{getOption("fflr.leagueId")}. Function fails if no ID is found.}

\item{leagueHistory}{logical; Should the \code{leagueHistory} version of the API
be called? If \code{TRUE}, a list of results is returned, with one element for
each historical year of the league.}

\item{...}{Additional queries passed to \code{\link[httr:GET]{httr::GET()}}
(e.g., \code{scoringPeriodId}). Arguments are converted to a named list to be
passed alongside \code{view}.}
}
\value{
A data frame of league scoring settings by season.
}
\description{
The scoring system used and points awarded for various actions.
}
\examples{
scoring_settings(leagueId = "42654852")
scoring_settings(leagueId = "252353", leagueHistory = TRUE)
}
\seealso{
Other League settings: 
\code{\link{acquisition_settings}()},
\code{\link{draft_settings}()},
\code{\link{finance_settings}()},
\code{\link{league_info}()},
\code{\link{league_name}()},
\code{\link{league_size}()},
\code{\link{roster_settings}()},
\code{\link{schedule_settings}()},
\code{\link{trade_settings}()}
}
\concept{League settings}
