% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-scores.R
\name{match_scores}
\alias{match_scores}
\title{Fantasy matchup scores}
\usage{
match_scores(lid = getOption("lid"), old = FALSE, ...)
}
\arguments{
\item{lid}{ESPN League ID, defaults to \code{getOption("lid")}. Use
\verb{options(lid = <League ID>)} to set your league ID; put that line in your
\code{.Rprofile} file to set the option at start up.}

\item{old}{If \code{FALSE} (default), return only the current season's data. If
\code{TRUE}, return a list with all prior seasons.}

\item{...}{Additional API query arguments. Use "week" and "year" as a
shorthand for "ScoringPeriodId" and "seasonId" respectively.}
}
\value{
A tibble (or list) of draft picks.
}
\description{
The score of each team in a matchup period, the match outcome, and the number
of league teams outscored (power wins).
}
\examples{
match_scores(lid = 252353)
}
