% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit-lmoments-kappa.R
\name{fit_lmoments_kappa}
\alias{fit_lmoments_kappa}
\title{L-Moments Parameter Estimation for the Kappa Distribution}
\usage{
fit_lmoments_kappa(data)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}
}
\value{
A list containing the results of parameter estimation:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{distribution}: \code{"KAP"}.
\item \code{method}: \code{"L-moments"}.
\item \code{params}: numeric vector of 4 parameters in the order location, scale, shape (2).
}
}
\description{
This function estimates the parameters of the four-parameter Kappa distribution
using the method of L-moments. Since no closed-form solution for the parameters
in terms of the L-moments is known, the parameters are estimated numerically
using Newton-Raphson iteration.
}
\details{
First, the sample L-moments of the data are computed using \code{\link[=utils_sample_lmoments]{utils_sample_lmoments()}}.
Then, the \code{\link[stats:optim]{stats::optim()}} function is used to determine the parameters
by minimizing the euclidian distance between the sample and theoretical L-moment
ratios. The implementation of this routine is based on the deprecated \code{homtest}
package, formerly available at \url{https://CRAN.R-project.org/package=homtest}.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
fit_lmoments_kappa(data)

}
\references{
Hosking, J.R.M. & Wallis, J.R., 1997. Regional frequency analysis: an approach based
on L-Moments. Cambridge University Press, New York, USA.
}
\seealso{
\code{\link[=utils_sample_lmoments]{utils_sample_lmoments()}}, \code{\link[=fit_lmoments]{fit_lmoments()}}
}
