% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eda-kpss-test.R
\name{eda_kpss_test}
\alias{eda_kpss_test}
\title{Kwiatkowski–Phillips–Schmidt–Shin (KPSS) Unit Root Test}
\usage{
eda_kpss_test(data, alpha = 0.05)
}
\arguments{
\item{data}{Numeric vector of observed annual maximum series values.
Must be strictly positive, finite, and not missing.}

\item{alpha}{Numeric scalar in \eqn{[0.01, 0.1]}. The significance
level for confidence intervals or hypothesis tests. Default is 0.05.}
}
\value{
A list containing the test results, including:
\itemize{
\item \code{data}: The \code{data} argument.
\item \code{alpha}: The significance level as specified in the \code{alpha} argument.
\item \code{null_hypothesis}: A string describing the null hypothesis.
\item \code{alternative_hypothesis}: A string describing the alternative hypothesis.
\item \code{statistic}: The KPSS test statistic.
\item \code{p_value}: The interpolated p-value. See the details for more information.
\item \code{reject}: If \code{TRUE}, the null hypothesis was rejected at significance \code{alpha}.
}
}
\description{
Performs the KPSS unit root test on annual maximum series data.
The null hypothesis is that the time series is trend-stationary with a linear
deterministic trend and constant drift. The alternative hypothesis is that the
time series has a unit root (also known as a stochastic trend).
}
\details{
The implementation of the KPSS test is based on the \pkg{aTSA} package, which
interpolates a significance table from Hobijn et al. (2004). Therefore, a result
of \eqn{p = 0.01} implies that \eqn{p \leq 0.01} and a result of \eqn{p = 0.10}
implies that \eqn{p \geq 0.10}.
}
\examples{
data <- rnorm(n = 100, mean = 100, sd = 10)
eda_kpss_test(data)

}
\references{
Hobijn, B., Franses, P.H. and Ooms, M. (2004), Generalizations of the KPSS-test
for stationarity. Statistica Neerlandica, 58: 483-502.

Kwiatkowski, D.; Phillips, P. C. B.; Schmidt, P.; Shin, Y. (1992). Testing the null
hypothesis of stationarity against the alternative of a unit root. Journal of
Econometrics, 54 (1-3): 159-178.
}
\seealso{
\code{\link[=eda_pp_test]{eda_pp_test()}}
}
