% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bind.R
\name{bind_random}
\alias{bind_random}
\title{Bind random bases in the projection bases space}
\usage{
bind_random(dt, n = 500, seed = 1)
}
\arguments{
\item{dt}{a data object collected by the projection pursuit guided tour optimisation in the \code{tourr} package}

\item{n}{numeric; the number of random bases to generate in each dimension by geozoo}

\item{seed}{numeric; a seed for generating reproducible random bases from geozoo}
}
\value{
a tibble object containing both the searched and random bases
}
\description{
Given the orthonormality constraint, the projection bases live in a high dimensional hollow sphere.
Generating random points on the sphere is useful to perceive the data object in the high dimensional space.
}
\examples{
bind_random(holes_1d_better) \%>\% tail(5)
}
\seealso{
Other bind: 
\code{\link{bind_random_matrix}()},
\code{\link{bind_theoretical}()}
}
\concept{bind}
