% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic.depth.R
\name{elastic.depth}
\alias{elastic.depth}
\title{Calculates elastic depth}
\usage{
elastic.depth(f, time, lambda = 0, pen = "roughness", parallel = FALSE)
}
\arguments{
\item{f}{matrix of sizes \eqn{M \times N}, specifying values of \eqn{N}
function of \eqn{M} time points}

\item{time}{vector of length \eqn{M}, specifying the sample points of functions}

\item{lambda}{controls amount of warping (default = \code{0})}

\item{pen}{alignment penalty (default = \code{"roughness"}) options are
second derivative (\code{"roughness"}), geodesic distance from id (\code{"geodesic"}),
and norm from id (\code{"norm"})}

\item{parallel}{run computation in parallel (default = \code{TRUE})}
}
\value{
Returns a list containing \item{amp}{amplitude depth}
\item{phase}{phase depth}
}
\description{
This functions calculates the elastic depth between set of functions in
\eqn{R^1}
}
\examples{
depths <- elastic.depth(simu_data$f[, 1:4], simu_data$time)
}
\references{
T. Harris, J. D. Tucker, B. Li, and L. Shand, "Elastic depths for
detecting shape anomalies in functional data," Technometrics,
10.1080/00401706.2020.1811156, 2020.
}
\concept{srvf alignment}
\keyword{depth}
