% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/curve_pair_align.R
\name{curve_pair_align}
\alias{curve_pair_align}
\title{Pairwise align two curves}
\usage{
curve_pair_align(beta1, beta2)
}
\arguments{
\item{beta1}{array describing curve 1 (n,T)}

\item{beta2}{array describing curve 2 (n,T)}
}
\value{
a list containing \item{beta2n}{aligned curve 2 to 1}
\item{q2n}{aligned srvf 2 to 1}
\item{gam}{warping function}
\item{q1}{srvf of curve 1}
}
\description{
This function aligns to curves using Elastic Framework
}
\examples{
out <- curve_pair_align(beta[, , 1, 1], beta[, , 1, 5])
}
\references{
Srivastava, A., Klassen, E., Joshi, S., Jermyn, I., (2011). Shape analysis of elastic curves in euclidean spaces. Pattern Analysis and Machine Intelligence, IEEE Transactions on 33 (7), 1415-1428.
}
\keyword{alignment}
\keyword{srvf}
