% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pair_align_functions_expomap.R
\name{pair_align_functions_expomap}
\alias{pair_align_functions_expomap}
\title{Align two functions using geometric properties of warping functions}
\usage{
pair_align_functions_expomap(
  f1,
  f2,
  timet,
  iter = 20000,
  burnin = min(5000, iter/2),
  alpha0 = 0.1,
  beta0 = 0.1,
  zpcn = list(betas = c(0.5, 0.05, 0.005, 1e-04), probs = c(0.1, 0.1, 0.7, 0.1)),
  propvar = 1,
  init.coef = rep(0, 2 * 10),
  npoints = 200,
  extrainfo = FALSE
)
}
\arguments{
\item{f1}{observed data, numeric vector}

\item{f2}{observed data, numeric vector}

\item{timet}{sample points of functions}

\item{iter}{length of the chain}

\item{burnin}{number of burnin MCMC iterations}

\item{alpha0, beta0}{IG parameters for the prior of sigma1}

\item{zpcn}{list of mixture coefficients and prior probabilities for
Z-mixture pCN algorithm of the form list(betas, probs), where betas and
probs are numeric vectors of equal length}

\item{propvar}{variance of proposal distribution}

\item{init.coef}{initial coefficients of warping function in exponential map;
length must be even}

\item{npoints}{number of sample points to use during alignment}

\item{extrainfo}{T/F whether additional information is returned}
}
\value{
Returns a list containing
\item{f2_warped}{f2 aligned to f1}
\item{gamma}{Posterior mean gamma function}
\item{g.coef}{matrix with iter columns, posterior draws of g.coef}
\item{psi}{Posterior mean psi function}
\item{sigma1}{numeric vector of length iter, posterior draws of sigma1}
\item{accept}{Boolean acceptance for each sample (if extrainfo=TRUE)}
\item{betas.ind}{Index of zpcn mixture component for each sample (if extrainfo=TRUE)}
\item{logl}{numeric vector of length iter, posterior loglikelihood (if extrainfo=TRUE)}
\item{gamma_mat}{Matrix of all posterior draws of gamma (if extrainfo=TRUE)}
\item{gamma_q025}{Lower 0.025 quantile of gamma (if extrainfo=TRUE)}
\item{gamma_q975}{Upper 0.975 quantile of gamma (if extrainfo=TRUE)}
\item{sigma_eff_size}{Effective sample size of sigma (if extrainfo=TRUE)}
\item{psi_eff_size}{Vector of effective sample sizes of psi (if extrainfo=TRUE)}
\item{xdist}{Vector of posterior draws from xdist between registered functions (if extrainfo=TRUE)}
\item{ydist}{Vector of posterior draws from ydist between registered functions (if extrainfo=TRUE)}
}
\description{
This function aligns two functions using Bayesian framework. It will align
f2 to f1. It is based on mapping warping functions to a hypersphere, and a
subsequent exponential mapping to a tangent space. In the tangent space,
the Z-mixture pCN algorithm is used to explore both local and global
structure in the posterior distribution.
}
\details{
The Z-mixture pCN algorithm uses a mixture distribution for the proposal
distribution, controlled by input parameter zpcn. The zpcn$betas must be
between 0 and 1, and are the coefficients of the mixture components, with
larger coefficients corresponding to larger shifts in parameter space. The
zpcn$probs give the probability of each shift size.
}
\examples{
\dontrun{
# This is a mcmc algorithm and takes a long time to run
data("simu_data")
myzpcn <- list(betas = c(0.1, 0.01, 0.005, 0.0001),
  probs = c(0.2, 0.2, 0.4, 0.2))
out = pair_align_functions_expomap(simu_data$f[,1], simu_data$f[,2],
  timet = simu_data$time, zpcn = myzpcn, extrainfo = TRUE)
# overall acceptance ratio
mean(out$accept)
# acceptance ratio by zpcn coefficient
with(out, tapply(accept, myzpcn$betas[betas.ind], mean))}
}
\references{
Lu, Y., Herbei, R., and Kurtek, S. (2017). Bayesian registration
of functions with a Gaussian process prior. Journal of Computational and
Graphical Statistics, DOI: 10.1080/10618600.2017.1336444.
}
