% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/warp_q_gamma.R
\name{warp_q_gamma}
\alias{warp_q_gamma}
\title{Warp SRSF}
\usage{
warp_q_gamma(q, time, gamma)
}
\arguments{
\item{q}{vector}

\item{time}{time}

\item{gamma}{vector warping function}
}
\value{
qnew warped function
}
\description{
This function warps srsf \eqn{q} by \eqn{\gamma}
}
\examples{
data("simu_data")
q = f_to_srvf(simu_data$f,simu_data$time)
qnew = warp_q_gamma(q[,1],simu_data$time,seq(0,1,length.out=101))
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
 May 2011. Registration of functional data using fisher-rao metric,
 arXiv:1103.3817v2 [math.ST].

Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srvf}

