% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/srsf_to_f.R
\name{srsf_to_f}
\alias{srsf_to_f}
\title{Convert SRSF to f}
\usage{
srsf_to_f(q, time, f0 = 0)
}
\arguments{
\item{q}{matrix of srsf}

\item{time}{time}

\item{f0}{initial value of f}
}
\value{
f matrix of functions
}
\description{
This function converts SRSFs to functions
}
\examples{
data("simu_data")
q = f_to_srvf(simu_data$f,simu_data$time)
f = srsf_to_f(q,simu_data$time,simu_data$f[1,])
}
\references{
Srivastava, A., Wu, W., Kurtek, S., Klassen, E., Marron, J. S.,
 May 2011. Registration of functional data using fisher-rao metric,
 arXiv:1103.3817v2 [math.ST].

Tucker, J. D., Wu, W., Srivastava, A.,
 Generative Models for Function Data using Phase and Amplitude Separation,
 Computational Statistics and Data Analysis (2012), 10.1016/j.csda.2012.12.001.
}
\keyword{alignment}
\keyword{srsf}

