% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted.FPCA.R
\name{fitted.FPCA}
\alias{fitted.FPCA}
\title{Fitted functional sample from FPCA object}
\usage{
\method{fitted}{FPCA}(object, K = NULL, derOptns = list(p = 0), ...)
}
\arguments{
\item{object}{A object of class FPCA returned by the function FPCA().}

\item{K}{The integer number of the first K components used for the representation. (default: length(fpcaObj$lambda ))}

\item{derOptns}{A list of options to control the derivation parameters specified by \code{list(name=value)}. See `Details'. (default = NULL)}

\item{...}{Additional arguments}
}
\value{
An \code{n} by \code{length(workGrid)} matrix, each row of which contains a sample.
}
\description{
Combine the zero-meaned fitted values and the interpolated mean to get the fitted values for the trajectories or the derivatives of these trajectories.
Estimates are given on the work-grid, not on the observation grid. Use ConvertSupport to map the estimates to your desired domain.
}
\details{
Available derivation control options are 
\describe{
\item{p}{The order of the derivatives returned (default: 0, max: 2)}
\item{method}{The method used to produce the sample of derivatives ('FPC' (default) or 'QUO'). See Liu and Mueller (2009) for more details}
\item{bw}{Bandwidth for smoothing the derivatives (default: p * 0.10 * S)}
\item{kernelType}{Smoothing kernel choice; same available types are FPCA(). default('epan')}
}
}
\examples{
set.seed(1)
n <- 20
pts <- seq(0, 1, by=0.05)
sampWiener <- Wiener(n, pts)
sampWiener <- Sparsify(sampWiener, pts, 10)
res <- FPCA(sampWiener$Ly, sampWiener$Lt, 
            list(dataType='Sparse', error=FALSE, kernel='epan', verbose=TRUE))
fittedY <- fitted(res)
}
\references{
\cite{Liu, Bitao, and Hans-Georg Mueller. "Estimating derivatives for samples of sparsely observed functions, with application to online auction dynamics." Journal of the American Statistical Association 104, no. 486 (2009): 704-717. (Sparse data FPCA)}
}

