% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multivariate_projection_depth.R
\name{projection_depth}
\alias{projection_depth}
\title{Random projection for multivariate data}
\usage{
projection_depth(dts, dt = dts, n_projections = 500L, seed = NULL)
}
\arguments{
\item{dts}{A matrix or data frame of size \code{m} observations by \code{d} dimension or vector of length \code{d}.
Contains the observation(s) whose depth is to be computed.}

\item{dt}{A matrix or dataframe of size \code{n} observations by \code{d} dimension. Equals to
\code{dts} by default.}

\item{n_projections}{The number of directions for random projections. By default,
500 random directions for projection are generated from a scaled uniform distribution between -1 and 1.}

\item{seed}{The random seed to set when generating the random directions. Defaults to NULL.}
}
\value{
A vector containing the depth values of \code{dts} with respect to \code{dt}.
}
\description{
Helper function to compute the random projection depth of multivariate point(s) with respect
to a multivariate data.
}
\examples{
projection_depth(dts = iris[1:5, -5], dt = iris[1:10, -5], n_projection = 7, seed = 20)

}
\seealso{
\code{\link{msplot}} for outlier detection using msplot and \code{\link{dir_out}}
 for directional outlyingness.
}
\author{
Oluwasegun Taiwo Ojo
}
