% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_FACF}
\alias{plot_FACF}
\title{Plot the autocorrelation function of a given FTS}
\usage{
plot_FACF(rho, Blueline, ci, ...)
}
\arguments{
\item{rho}{Autocorrelation values for each lag of
the functional time series obtained by calling the
function \code{obtain_FACF}.}

\item{Blueline}{The upper prediction bound for the
i.i.d. distribution obtained by calling the
function \code{obtain_FACF}.}

\item{ci}{Value between 0 and 1 that was used
when calling the function \code{obtain_FACF}.
This value is only used to display information
in the figure.}

\item{...}{Further arguments passed to the  \code{plot}
function.}
}
\description{
Plot a visual representation of the autocorrelation function
of a given functional time series, including the upper i.i.d.
bound.
}
\examples{
# Example 1

N <- 100
v <- seq(from = 0, to = 1, length.out = 10)
sig <- 2
bbridge <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 15
upper_bound <- 0.95
fACF <- obtain_FACF(Y = bbridge,v = v,nlags = nlags,ci=upper_bound,figure = FALSE)
plot_FACF(rho = fACF$rho,Blueline = fACF$Blueline,ci = upper_bound)

\donttest{
# Example 2

N <- 200
v <- seq(from = 0, to = 1, length.out = 30)
sig <- 2
bbridge <- simulate_iid_brownian_bridge(N, v, sig)
nlags <- 15
upper_bound <- 0.95
fACF <- obtain_FACF(Y = bbridge,v = v,nlags = nlags,ci=upper_bound,figure = FALSE)
plot_FACF(rho = fACF$rho,Blueline = fACF$Blueline,ci = upper_bound)
}
}
