% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_distribution.R
\name{obtain_autocov_eigenvalues}
\alias{obtain_autocov_eigenvalues}
\title{Estimate eigenvalues of the autocovariance function}
\usage{
obtain_autocov_eigenvalues(v, Y, epsilon = 1e-04)
}
\arguments{
\item{v}{Discretization points of the curves, by default
\code{seq(from = 0, to = 1, length.out = 100)}.}

\item{Y}{Matrix containing the discretized values
of the functional time series. The dimension of the
matrix is \eqn{(n x m)}, where \eqn{n} is the
number of curves and \eqn{m} is the number of points
observed in each curve.}

\item{epsilon}{Value used to determine how many
eigenvalues will be returned. The eigenvalues
\eqn{\lambda_{j} > \code{epsilon}} will be returned.
By default \code{epsilon = 0.0001}.}
}
\value{
A vector containing the \eqn{k} eigenvalues
greater than \code{epsilon}.
}
\description{
Estimate the eigenvalues of the sample autocovariance
function \eqn{\hat{C}_{0}}. This functions returns the
eigenvalues which are greater than the value \code{epsilon}.
}
\examples{
N <- 100
v <- seq(from = 0, to = 1, length.out = 10)
sig <- 2
Y <- simulate_iid_brownian_bridge(N, v, sig)
lambda <- obtain_autocov_eigenvalues(v = v, Y = Y)

}
