\name{eval.basis}
\alias{eval.basis}
\title{
  Values of Basis Functions or their Derivatives
}
\description{
  A set of basis functions are evaluated at a vector of argument values.
  If a linear differential object is provided, the  values are the
  result of applying the the operator to each basis function. 
}
\usage{
eval.basis(evalarg, basisobj, Lfdobj=0)
}
\arguments{
  \item{evalarg}{
    a vector of argument values.
  }
  \item{basisobj}{
    a basis object defining basis functions whose values
    are to be computed.
  }
  \item{Lfdobj}{
    either a nonnegative integer or a linear differential.
    operator object.
  }
}
\value{
  a matrix of basis function values with rows corresponding
  to argument values and columns to basis functions.
}
\details{
  If a linear differential operator object is supplied, the basis must
  be such that the highest order derivative can be computed. If a
  B-spline basis is used, for example, its order must be one larger than
  the highest order of derivative required.
}
\source{
  Ramsay, James O., and Silverman, Bernard W. (2006), \emph{Functional
    Data Analysis, 2nd ed.}, Springer, New York.

  Ramsay, James O., and Silverman, Bernard W. (2002), \emph{Applied
    Functional Data Analysis}, Springer, New York
}
\seealso{
  \code{\link{getbasismatrix}}, 
  \code{\link{eval.fd}}, 
  \code{\link{plot.basisfd}}
}
\examples{
##
## 1.  B-splines
## 
# The simplest basis currently available:
# a single step function  
str(bspl1.1 <- create.bspline.basis(norder=1, breaks=0:1))
(eval.bspl1.1 <- eval.basis(seq(0, 1, .2), bspl1.1))

# The second simplest basis:
# 2 step functions, [0, .5], [.5, 1]
str(bspl1.2 <- create.bspline.basis(norder=1, breaks=c(0,.5, 1)))
(eval.bspl1.2 <- eval.basis(seq(0, 1, .2), bspl1.2))

# Second order B-splines (degree 1:  linear splines) 
str(bspl2.3 <- create.bspline.basis(norder=2, breaks=c(0,.5, 1)))
(eval.bspl2.3 <- eval.basis(seq(0, 1, .1), bspl2.3))
# 3 bases:  order 2 = degree 1 = linear 
# (1) line from (0,1) down to (0.5, 0), 0 after
# (2) line from (0,0) up to (0.5, 1), then down to (1,0)
# (3) 0 to (0.5, 0) then up to (1,1).

##
## 2.  Fourier 
## 
# The false Fourier series with 1 basis function
falseFourierBasis <- create.fourier.basis(nbasis=1)
(eval.fFB <- eval.basis(seq(0, 1, .2), falseFourierBasis))

# Simplest real Fourier basis with 3 basis functions
fourier3 <- create.fourier.basis()
(eval.fourier3 <- eval.basis(seq(0, 1, .2), fourier3))

# 3 basis functions on [0, 365]
fourier3.365 <- create.fourier.basis(c(0, 365))
eval.F3.365 <- eval.basis(day.5, fourier3.365)

matplot(eval.F3.365, type="l")

# The next simplest Fourier basis (5  basis functions)
fourier5 <- create.fourier.basis(nbasis=5)
(eval.F5 <- eval.basis(seq(0, 1, .1), fourier5))
matplot(eval.F5, type="l")

# A more complicated example
dayrng <- c(0, 365) 

nbasis <- 51
norder <- 6 

weatherBasis <- create.fourier.basis(dayrng, nbasis)
basisMat <- eval.basis(day.5, weatherBasis) 

matplot(basisMat[, 1:5], type="l")

}
% docclass is function
\keyword{smooth}
