% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif.gkam.R
\name{classif.gkam}
\alias{classif.gkam}
\title{Classification Fitting Functional Generalized Kernel Additive Models}
\usage{
classif.gkam(
  formula,
  data,
  weights = "equal",
  family = binomial(),
  par.metric = NULL,
  par.np = NULL,
  offset = NULL,
  prob = 0.5,
  type = "1vsall",
  control = NULL,
  ...
)
}
\arguments{
\item{formula}{an object of class \code{formula} (or one that can be coerced
to that class): a symbolic description of the model to be fitted. The
procedure only considers functional covariates (not implemented for
non-functional covariates). The details of model specification are given
under \code{Details}.}

\item{data}{List that containing the variables in the model.}

\item{weights}{Weights:
\itemize{
\item if \code{character} string \code{='equal'} same weights for each observation (by default) and
\code{='inverse'} for inverse-probability of weighting.   
\item if \code{numeric} vector of length \code{n}, Weight values of each observation.
}}

\item{family}{a description of the error distribution and link function to
be used in the model. This can be a character string naming a family
function, a family function or the result of a call to a family function.
(See \code{\link{family}} for details of family functions.)}

\item{par.metric}{List of arguments by covariable to pass to the
\code{metric} function by covariable.}

\item{par.np}{List of arguments to pass to the \code{fregre.np.cv} function}

\item{offset}{this can be used to specify an a priori known component to be
included in the linear predictor during fitting.}

\item{prob}{probability value used for binary discriminant.}

\item{type}{If type is\code{"1vsall"}  (by default) 
a maximum probability scheme is applied: requires G binary classifiers.
If type is \code{"majority"}  (only for multicalss classification G > 2) 
a voting scheme is applied: requires  G (G - 1) / 2 binary classifiers.}

\item{control}{a list of parameters for controlling the fitting process, by
default: maxit, epsilon, trace and inverse.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Return \code{gam} object plus:
\itemize{
\item \code{formula}{ formula.}
\item \code{data}{ List that containing the variables in the model.} 
\item \code{group}{ Factor of length \emph{n}} 
\item \code{group.est}{ Estimated vector groups}
\item \code{prob.classification}{ Probability of correct classification by group.}
\item \code{prob.group}{ Matrix of predicted class probabilities. For each
functional point shows the probability of each possible group membership.}
\item \code{max.prob}{ Highest probability of correct classification.}
}
}
\description{
Computes functional classification using functional explanatory variables
using backfitting algorithm.
}
\details{
The first item in the \code{data} list is called \emph{"df"} and is a data
frame with the response, as \code{\link{glm}}.\cr Functional covariates of
class \code{fdata} are introduced in the following items in the \code{data}
list.
}
\examples{
\dontrun{ 
## Time-consuming: selection of 2 levels 
data(phoneme)
mlearn<-phoneme[["learn"]][1:150]
glearn<-factor(phoneme[["classlearn"]][1:150])
dataf<-data.frame(glearn)
dat=list("df"=dataf,"x"=mlearn)
a1<-classif.gkam(glearn~x,data=dat)
summary(a1)
mtest<-phoneme[["test"]][1:150]
gtest<-factor(phoneme[["classtest"]][1:150])
newdat<-list("x"=mtest)
p1<-predict(a1,newdat)
table(gtest,p1)
}  
}
\references{
Febrero-Bande M. and Gonzalez-Manteiga W. (2012).
\emph{Generalized Additive Models for Functional Data}. TEST.
Springer-Velag.  \doi{10.1007/s11749-012-0308-0}

McCullagh and Nelder (1989), \emph{Generalized Linear Models} 2nd ed.
Chapman and Hall.

Opsomer J.D. and Ruppert D.(1997). \emph{Fitting a bivariate additive model
by local polynomial regression}.Annals of Statistics, \code{25}, 186-211.
}
\seealso{
See Also as: \code{\link{fregre.gkam}}.\cr Alternative method:
\code{\link{classif.glm}}.
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{classif}
