% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GCV.S.R
\name{GCV.S}
\alias{GCV.S}
\title{The generalized correlated cross-validation (GCCV) score}
\usage{
GCV.S(
  y,
  S,
  criteria = "GCV",
  W = NULL,
  trim = 0,
  draw = FALSE,
  metric = metric.lp,
  ...
)
}
\arguments{
\item{y}{Matrix of set cases with dimension (\code{n} x \code{m}), where
\code{n} is the number of curves and \code{m} are the points observed in
each curve.}

\item{S}{Smoothing matrix, see \code{\link{S.NW}}, \code{\link{S.LLR}} or}

\item{criteria}{The penalizing function. By default \emph{"Rice"} criteria. 
Possible values are \emph{"GCCV1"}, \emph{"GCCV2"}, \emph{"GCCV3"}, \emph{"GCV"}.}

\item{W}{Matrix of weights.}

\item{trim}{The alpha of the trimming.}

\item{draw}{=TRUE, draw the curves, the sample median and trimmed mean.}

\item{metric}{Metric function, by default \code{\link{metric.lp}}.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
{ Returns GCV score calculated for input parameters.  }
}
\description{
Compute the  generalized correlated cross-validation (GCV) score.
}
\details{
A.-If \code{trim=0}:\cr
\deqn{GCCV=\frac{\sum_{i=1}^n {y_{i}-\hat{y}_{i,b}}^2}{1-\frac{tr(C)}{n}^2}}{\sum(y-y.fit)^2 / (1-tr(C)/n)^2} 
where \eqn{S} is the smoothing matrix \eqn{S} and:\cr
A.-If \eqn{C=2S\Sigma - S\Sigma S} \cr
B.-If  \eqn{C=S\Sigma} \cr
C.-If  \eqn{C=S\Sigma S'} \cr
with \eqn{\Sigma} is the n x n covariance matrix with
\eqn{cor(\epsilon_i,\epsilon_j ) =\sigma}
Note: Provided that \eqn{C = I} and the smoother matrix S is symmetric and idempotent, as is the case for many linear fitting techniques, the trace term reduces to  \eqn{n - tr[S]}, which is proportional to the familiar denominator in GCV.
}
\examples{
\dontrun{
data(phoneme)
mlearn<-phoneme$learn
tt<-1:ncol(mlearn)
S1 <- S.NW(tt,2.5)
S2 <- S.LLR(tt,2.5)
gcv1 <- GCV.S(mlearn, S1)
gcv2 <- GCV.S(mlearn, S2)
gcv3 <- GCV.S(mlearn, S1,criteria="AIC")
gcv4 <- GCV.S(mlearn, S2,criteria="AIC")
gcv1; gcv2; gcv3; gcv4
}
 
}
\references{
Wasserman, L. \emph{All of Nonparametric Statistics}. Springer Texts in Statistics, 2006. 
Hardle, W. \emph{Applied Nonparametric Regression}. Cambridge University Press, 1994.
Febrero-Bande,  M., Oviedo de la Fuente, M. (2012).  \emph{Statistical Computing in Functional Data Analysis: The R Package fda.usc.}
Journal of Statistical Software, 51(4), 1-28. \url{https://www.jstatsoft.org/v51/i04/}
}
\seealso{
See Also as \code{\link{optim.np}} \cr Alternative method:
\code{\link{CV.S}}
}
\author{
Manuel Febrero-Bande, Manuel Oviedo de la Fuente
\email{manuel.oviedo@udc.es}
}
\keyword{utilities}
