% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif.ML.R
\name{classif.ML}
\alias{classif.ML}
\alias{classif.nnet}
\alias{classif.rpart}
\alias{classif.randomForest}
\alias{classif.cv.glmnet}
\alias{classif.svm}
\alias{classif.ksvm}
\alias{classif.naiveBayes}
\alias{classif.lda}
\alias{classif.qda}
\alias{classif.multinom}
\alias{classif.gbm}
\title{Functional classification using ML algotithms}
\usage{
classif.nnet(formula, data, basis.x = NULL, weights = "equal", size, ...)

classif.rpart(
  formula,
  data,
  basis.x = NULL,
  weights = "equal",
  type = "1vsall",
  ...
)

classif.svm(
  formula,
  data,
  basis.x = NULL,
  weights = "equal",
  type = "1vsall",
  ...
)

classif.ksvm(formula, data, basis.x = NULL, weights = "equal", ...)

classif.randomForest(
  formula,
  data,
  basis.x = NULL,
  weights = "equal",
  type = "1vsall",
  ...
)

classif.lda(
  formula,
  data,
  basis.x = NULL,
  weights = "equal",
  type = "1vsall",
  ...
)

classif.qda(
  formula,
  data,
  basis.x = NULL,
  weights = "equal",
  type = "1vsall",
  ...
)

classif.naiveBayes(formula, data, basis.x = NULL, laplace = 0, ...)

classif.cv.glmnet(formula, data, basis.x = NULL, weights = "equal", ...)

classif.gbm(formula, data, basis.x = NULL, weights = "equal", ...)
}
\arguments{
\item{formula}{an object of class \code{formula} (or one that can be coerced
to that class): a symbolic description of the model to be fitted. The
details of model specification are given under \code{Details}.}

\item{data}{List that containing the variables in the model.}

\item{basis.x}{List of basis for functional explanatory data estimation.}

\item{weights}{Weights:
\itemize{
\item if \code{character} string \code{='equal'} same weights for each observation (by default) and
\code{='inverse'} for inverse-probability of weighting.   
\item if \code{numeric} vector of length \code{n}, Weight values of each observation.
}}

\item{size}{number of units in the hidden layer. Can be zero if there are skip-layer units.}

\item{\dots}{Further arguments passed to or from other methods.}

\item{type}{If type is\code{"1vsall"}  (by default) 
a maximum probability scheme is applied: requires G binary classifiers.
If type is \code{"majority"}  (only for multicalss classification G > 2) 
a voting scheme is applied: requires  G (G - 1) / 2 binary classifiers.}

\item{laplace}{value used for Laplace smoothing (additive smoothing). Defaults to 0 (no Laplace smoothing).}
}
\value{
Return \code{classif} object plus:
\itemize{
\item \code{formula}{ formula.}
\item \code{data}{ List that containing the variables in the model.} 
\item \code{group}{ Factor of length \emph{n}} 
\item \code{group.est}{ Estimated vector groups}
\item \code{prob.classification}{ Probability of correct classification by group.}
\item \code{prob.group}{ Matrix of predicted class probabilities. For each
functional point shows the probability of each possible group membership.}
\item \code{max.prob}{ Highest probability of correct classification.}
\item \code{type}  Type of classification scheme: 1 vs all  or majority voting.
\item \code{fit} list of binary classification fitted models.
}
}
\description{
Computes functional classification using functional (and non functional)
explanatory variables by rpart, nnet, svm or random forest model
}
\details{
The first item in the \code{data} list is called \emph{"df"} and is a data
frame with the response and non functional explanatory variables, as
\code{\link{glm}}.\cr

Functional covariates of class \code{fdata} or \code{fd} are introduced in
the following items in the \code{data} list.\cr \code{basis.x} is a list of
basis for represent each functional covariate. The b object can be
created by the function: \code{\link{create.pc.basis}}, \code{\link{pca.fd}}
\code{\link{create.pc.basis}}, \code{\link{create.fdata.basis}} o
\code{\link{create.basis}}.\cr \code{basis.b} is a list of basis for
represent each functional beta parameter. If \code{basis.x} is a list of
functional principal components basis (see \code{\link{create.pc.basis}} or
\code{\link{pca.fd}}) the argument \code{basis.b} is ignored.
}
\note{
Wrapper versions for multivariate and functional classification:
\itemize{
\item \code{classif.lda},\code{classif.qda}: uses \code{lda} and  \code{qda} functions and requires \code{MASS} package.
\item \code{classif.nnet}: uses \code{nnet} function and requires \code{nnet} package.
\item \code{classif.rpart}: uses \code{nnet} function and requires \code{rpart} package.
\item \code{classif.svm},\code{classif.naiveBayes}: uses \code{svm} and  \code{naiveBayes} functions and requires \code{e1071} package.
\item \code{classif.ksvm}: uses \code{weighted.ksvm } function and requires \code{personalized} package.
\item \code{classif.randomForest}: uses \code{randomForest} function and requires \code{randomForest} package.
\item \code{classif.cv.glmnet}: uses \code{cv.glmnet} function and requires \code{glmnet} package.
\item \code{classif.gbm}: uses \code{gbm} function and requires \code{gbm} package.
}
}
\examples{
\dontrun{
data(phoneme)
mlearn<-phoneme[["learn"]]
glearn<-phoneme[["classlearn"]]
mtest<-phoneme[["test"]]
gtest<-phoneme[["classtest"]]
dataf<-data.frame(glearn)
dat=ldata("df"=dataf,"x"=mlearn)
a1<-classif.rpart(glearn~x,data=dat)
a2<-classif.nnet(glearn~x,data=dat)
a3<-classif.gbm(glearn~x,data=dat)
a4<-classif.randomForest(glearn~x,data=dat)
a5<-classif.cv.glmnet(glearn~x,data=dat)
newdat<-list("x"=mtest)
p1<-predict(a1,newdat,type="class")
p2<-predict(a2,newdat,type="class")
p3<-predict(a3,newdat,type="class")
p4<-predict(a4,newdat,type="class")
p5<-predict(a5,newdat,type="class")
mean(p1==gtest);mean(p2==gtest);mean(p3==gtest)
mean(p4==gtest);mean(p5==gtest)
}

}
\references{
Ramsay, James O., and Silverman, Bernard W. (2006), 
\emph{Functional Data Analysis}, 2nd ed., Springer, New York. 

McCullagh and Nelder (1989), \emph{Generalized Linear Models} 2nd ed. Chapman and Hall.

Venables, W. N. and Ripley, B. D. (2002) \emph{Modern Applied Statistics
with S}, New York: Springer.  %Wood (2001) mgcv:GAMs and Generalized Ridge
Regression for R. R News 1(2):20-25
}
\seealso{
See Also as: \code{\link{rpart}}.\cr Alternative method:
\code{\link{classif.np}}, \code{\link{classif.glm}},
\code{\link{classif.gsam}} and \code{\link{classif.gkam}}.
}
\author{
Febrero-Bande, M. and Oviedo de la Fuente, M.
}
\keyword{classif}
