% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accuracy.R
\name{accuracy}
\alias{accuracy}
\alias{cat2meas}
\alias{tab2meas}
\alias{pred2meas.}
\alias{pred.MSE}
\alias{pred.RMSE}
\alias{pred.MAE}
\alias{pred2meas}
\title{Performance measures for regression and classification models}
\usage{
cat2meas(yobs, ypred, measure = "accuracy", cost = rep(1, nlevels(yobs)))

tab2meas(tab, measure = "accuracy", cost = rep(1, nrow(tab)))

pred.MSE(yobs, ypred)

pred.RMSE(yobs, ypred)

pred.MAE(yobs, ypred)

pred2meas(yobs, ypred, measure = "RMSE")
}
\arguments{
\item{yobs}{A vector of the labels, true class or observed response. Can be \code{numeric}, \code{character}, or \code{factor}.}

\item{ypred}{A vector of the predicted labels, predicted class or predicted response. Can be \code{numeric, character, or factor}.}

\item{measure}{Type of measure, see \code{details} section.}

\item{cost}{Cost value by class (only for input factors).}

\item{tab}{Confusion matrix (Contingency table: observed class by rows, predicted class by columns).}
}
\description{
\code{\link{cat2meas}} and \code{\link{tab2meas}} calculate the measures for a multiclass classification model.\cr
 \code{\link{pred2meas}} calculates the measures for a regression model.
}
\details{
\itemize{
\item \code{\link{cat2meas}} compute \eqn{tab=table(yobs,ypred)} and calls \code{\link{tab2meas}} function.
\item \code{\link{tab2meas}} function computes the following measures (see \code{measure} argument) for a binary classification model:
\itemize{
\item \code{accuracy}{ the accuracy classification score}
\item \code{recall}, \code{sensitivity,TPrate}{ \eqn{R=TP/(TP+FN)}}
\item \code{precision}{ \eqn{P=TP/(TP+FP)}}
\item \code{specificity},\code{TNrate}{ \eqn{TN/(TN+FP)}}
\item \code{FPrate}{ \eqn{FP/(TN+FP)}}
\item \code{FNrate}{ \eqn{FN/(TP+FN)}}
\item \code{Fmeasure}{ \eqn{2/(1/R+1/P)}}
\item \code{Gmean}{ \eqn{sqrt(R*TN/(TN+FP))}}
\item \code{kappa}{ the kappa index}
\item \code{cost}{ \eqn{sum(diag(tab)/rowSums(tab)*cost)/sum(cost)}}
}
\item \code{\link{pred2meas}} function computes the following  measures of error, usign the \code{measure} argument, for observed and predicted vectors:
\itemize{
\item \code{MSE}{ Mean squared error, \eqn{\frac{\sum{(ypred- yobs)^2}}{n} }{\sum (ypred- yobs)^2 /n }}
\item \code{RMSE}{ Root mean squared error \eqn{\sqrt{\frac{\sum{(ypred- yobs)^2}}{n} }}{\sqrt(\sum (ypred- yobs)^2 /n )}}
\item \code{MAE}{ Mean Absolute Error, \eqn{\frac{\sum |yobs - ypred|}{n}}{\sum |yobs - ypred| /n}}
}
}
}
\seealso{
Other performance: 
\code{\link{weights4class}()}
}
\concept{performance}
